@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlPoolWorkloadClassifier].
 */
@PulumiTagMarker
public class SqlPoolWorkloadClassifierResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlPoolWorkloadClassifierArgs = SqlPoolWorkloadClassifierArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlPoolWorkloadClassifierArgsBuilder.() -> Unit) {
        val builder = SqlPoolWorkloadClassifierArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlPoolWorkloadClassifier {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifier(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlPoolWorkloadClassifier(builtJavaResource)
    }
}

/**
 * Workload classifier operations for a data warehouse
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create a workload classifier with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolWorkloadClassifier = new AzureNative.Synapse.SqlPoolWorkloadClassifier("sqlPoolWorkloadClassifier", new()
 *     {
 *         Context = "test_context",
 *         EndTime = "14:00",
 *         Importance = "high",
 *         Label = "test_label",
 *         MemberName = "dbo",
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         StartTime = "12:00",
 *         WorkloadClassifierName = "wlm_workloadclassifier",
 *         WorkloadGroupName = "wlm_workloadgroup",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolWorkloadClassifier(ctx, "sqlPoolWorkloadClassifier", &synapse.SqlPoolWorkloadClassifierArgs{
 * 			Context:                pulumi.String("test_context"),
 * 			EndTime:                pulumi.String("14:00"),
 * 			Importance:             pulumi.String("high"),
 * 			Label:                  pulumi.String("test_label"),
 * 			MemberName:             pulumi.String("dbo"),
 * 			ResourceGroupName:      pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:            pulumi.String("sqlcrudtest-9187"),
 * 			StartTime:              pulumi.String("12:00"),
 * 			WorkloadClassifierName: pulumi.String("wlm_workloadclassifier"),
 * 			WorkloadGroupName:      pulumi.String("wlm_workloadgroup"),
 * 			WorkspaceName:          pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifier;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolWorkloadClassifier = new SqlPoolWorkloadClassifier("sqlPoolWorkloadClassifier", SqlPoolWorkloadClassifierArgs.builder()
 *             .context("test_context")
 *             .endTime("14:00")
 *             .importance("high")
 *             .label("test_label")
 *             .memberName("dbo")
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .startTime("12:00")
 *             .workloadClassifierName("wlm_workloadclassifier")
 *             .workloadGroupName("wlm_workloadgroup")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workload classifier with the required properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolWorkloadClassifier = new AzureNative.Synapse.SqlPoolWorkloadClassifier("sqlPoolWorkloadClassifier", new()
 *     {
 *         MemberName = "dbo",
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         WorkloadClassifierName = "wlm_workloadclassifier",
 *         WorkloadGroupName = "wlm_workloadgroup",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolWorkloadClassifier(ctx, "sqlPoolWorkloadClassifier", &synapse.SqlPoolWorkloadClassifierArgs{
 * 			MemberName:             pulumi.String("dbo"),
 * 			ResourceGroupName:      pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:            pulumi.String("sqlcrudtest-9187"),
 * 			WorkloadClassifierName: pulumi.String("wlm_workloadclassifier"),
 * 			WorkloadGroupName:      pulumi.String("wlm_workloadgroup"),
 * 			WorkspaceName:          pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifier;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolWorkloadClassifier = new SqlPoolWorkloadClassifier("sqlPoolWorkloadClassifier", SqlPoolWorkloadClassifierArgs.builder()
 *             .memberName("dbo")
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .workloadClassifierName("wlm_workloadclassifier")
 *             .workloadGroupName("wlm_workloadgroup")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolWorkloadClassifier wlm_workloadclassifier /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/workloadGroups/{workloadGroupName}/workloadClassifiers/{workloadClassifierName}
 * ```
 */
public class SqlPoolWorkloadClassifier internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifier,
) : KotlinCustomResource(javaResource, SqlPoolWorkloadClassifierMapper) {
    /**
     * The workload classifier context.
     */
    public val context: Output<String>?
        get() = javaResource.context().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The workload classifier end time for classification.
     */
    public val endTime: Output<String>?
        get() = javaResource.endTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The workload classifier importance.
     */
    public val importance: Output<String>?
        get() = javaResource.importance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The workload classifier label.
     */
    public val label: Output<String>?
        get() = javaResource.label().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The workload classifier member name.
     */
    public val memberName: Output<String>
        get() = javaResource.memberName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The workload classifier start time for classification.
     */
    public val startTime: Output<String>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlPoolWorkloadClassifierMapper : ResourceMapper<SqlPoolWorkloadClassifier> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifier::class == javaResource::class

    override fun map(javaResource: Resource): SqlPoolWorkloadClassifier =
        SqlPoolWorkloadClassifier(
            javaResource as
                com.pulumi.azurenative.synapse.SqlPoolWorkloadClassifier,
        )
}

/**
 * @see [SqlPoolWorkloadClassifier].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlPoolWorkloadClassifier].
 */
public suspend fun sqlPoolWorkloadClassifier(
    name: String,
    block: suspend SqlPoolWorkloadClassifierResourceBuilder.() -> Unit,
): SqlPoolWorkloadClassifier {
    val builder = SqlPoolWorkloadClassifierResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlPoolWorkloadClassifier].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlPoolWorkloadClassifier(name: String): SqlPoolWorkloadClassifier {
    val builder = SqlPoolWorkloadClassifierResourceBuilder()
    builder.name(name)
    return builder.build()
}
