@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the spark config properties file.
 */
public enum class ConfigurationType(
    public val javaValue: com.pulumi.azurenative.synapse.enums.ConfigurationType,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.enums.ConfigurationType> {
    File(com.pulumi.azurenative.synapse.enums.ConfigurationType.File),
    Artifact(com.pulumi.azurenative.synapse.enums.ConfigurationType.Artifact),
    ;

    override fun toJava(): com.pulumi.azurenative.synapse.enums.ConfigurationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.enums.ConfigurationType):
            ConfigurationType = ConfigurationType.values().first { it.javaValue == javaType }
    }
}
