@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.ComponentSetupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The custom setup of installing 3rd party components.
 * @property componentName The name of the 3rd party component.
 * @property licenseKey The license key to activate the component.
 * @property type The type of custom setup.
 * Expected value is 'ComponentSetup'.
 */
public data class ComponentSetupArgs(
    public val componentName: Output<String>,
    public val licenseKey: Output<SecureStringArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.ComponentSetupArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.ComponentSetupArgs =
        com.pulumi.azurenative.synapse.inputs.ComponentSetupArgs.builder()
            .componentName(componentName.applyValue({ args0 -> args0 }))
            .licenseKey(licenseKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComponentSetupArgs].
 */
@PulumiTagMarker
public class ComponentSetupArgsBuilder internal constructor() {
    private var componentName: Output<String>? = null

    private var licenseKey: Output<SecureStringArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the 3rd party component.
     */
    @JvmName("gjsfjcgnvgkbnxbp")
    public suspend fun componentName(`value`: Output<String>) {
        this.componentName = value
    }

    /**
     * @param value The license key to activate the component.
     */
    @JvmName("ovytgrrwdchnoyah")
    public suspend fun licenseKey(`value`: Output<SecureStringArgs>) {
        this.licenseKey = value
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'ComponentSetup'.
     */
    @JvmName("rmpmenfdppvhhreb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the 3rd party component.
     */
    @JvmName("kksegpovjngrtxtt")
    public suspend fun componentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentName = mapped
    }

    /**
     * @param value The license key to activate the component.
     */
    @JvmName("mfgnjlfpnaqlhrjl")
    public suspend fun licenseKey(`value`: SecureStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseKey = mapped
    }

    /**
     * @param argument The license key to activate the component.
     */
    @JvmName("nymgdwlsgajsdonc")
    public suspend fun licenseKey(argument: suspend SecureStringArgsBuilder.() -> Unit) {
        val toBeMapped = SecureStringArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.licenseKey = mapped
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'ComponentSetup'.
     */
    @JvmName("jemsefjvwriyhupi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ComponentSetupArgs = ComponentSetupArgs(
        componentName = componentName ?: throw PulumiNullFieldException("componentName"),
        licenseKey = licenseKey,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
