@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.DynamicExecutorAllocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dynamic Executor Allocation Properties
 * @property enabled Indicates whether Dynamic Executor Allocation is enabled or not.
 * @property maxExecutors The maximum number of executors alloted
 * @property minExecutors The minimum number of executors alloted
 */
public data class DynamicExecutorAllocationArgs(
    public val enabled: Output<Boolean>? = null,
    public val maxExecutors: Output<Int>? = null,
    public val minExecutors: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.DynamicExecutorAllocationArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.DynamicExecutorAllocationArgs =
        com.pulumi.azurenative.synapse.inputs.DynamicExecutorAllocationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .maxExecutors(maxExecutors?.applyValue({ args0 -> args0 }))
            .minExecutors(minExecutors?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DynamicExecutorAllocationArgs].
 */
@PulumiTagMarker
public class DynamicExecutorAllocationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var maxExecutors: Output<Int>? = null

    private var minExecutors: Output<Int>? = null

    /**
     * @param value Indicates whether Dynamic Executor Allocation is enabled or not.
     */
    @JvmName("lltetimvhxukjcip")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The maximum number of executors alloted
     */
    @JvmName("ytxaactdtqhsosab")
    public suspend fun maxExecutors(`value`: Output<Int>) {
        this.maxExecutors = value
    }

    /**
     * @param value The minimum number of executors alloted
     */
    @JvmName("gbncwaojvlbhyedc")
    public suspend fun minExecutors(`value`: Output<Int>) {
        this.minExecutors = value
    }

    /**
     * @param value Indicates whether Dynamic Executor Allocation is enabled or not.
     */
    @JvmName("vsktoxvvmfuuvdue")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The maximum number of executors alloted
     */
    @JvmName("kxpyfdqmjgikrxqi")
    public suspend fun maxExecutors(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxExecutors = mapped
    }

    /**
     * @param value The minimum number of executors alloted
     */
    @JvmName("rynwxnhjighgdncn")
    public suspend fun minExecutors(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minExecutors = mapped
    }

    internal fun build(): DynamicExecutorAllocationArgs = DynamicExecutorAllocationArgs(
        enabled = enabled,
        maxExecutors = maxExecutors,
        minExecutors = minExecutors,
    )
}
