@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.EnvironmentVariableSetupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The custom setup of setting environment variable.
 * @property type The type of custom setup.
 * Expected value is 'EnvironmentVariableSetup'.
 * @property variableName The name of the environment variable.
 * @property variableValue The value of the environment variable.
 */
public data class EnvironmentVariableSetupArgs(
    public val type: Output<String>,
    public val variableName: Output<String>,
    public val variableValue: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.EnvironmentVariableSetupArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.EnvironmentVariableSetupArgs =
        com.pulumi.azurenative.synapse.inputs.EnvironmentVariableSetupArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .variableName(variableName.applyValue({ args0 -> args0 }))
            .variableValue(variableValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentVariableSetupArgs].
 */
@PulumiTagMarker
public class EnvironmentVariableSetupArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var variableName: Output<String>? = null

    private var variableValue: Output<String>? = null

    /**
     * @param value The type of custom setup.
     * Expected value is 'EnvironmentVariableSetup'.
     */
    @JvmName("cqwipnmudlnyikgr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the environment variable.
     */
    @JvmName("larbkigyixhsbiup")
    public suspend fun variableName(`value`: Output<String>) {
        this.variableName = value
    }

    /**
     * @param value The value of the environment variable.
     */
    @JvmName("iebddadrhydgxdvo")
    public suspend fun variableValue(`value`: Output<String>) {
        this.variableValue = value
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'EnvironmentVariableSetup'.
     */
    @JvmName("weuvjmqxkrhxnanf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The name of the environment variable.
     */
    @JvmName("oaqigihykskhnbpq")
    public suspend fun variableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    /**
     * @param value The value of the environment variable.
     */
    @JvmName("tcfxugrhnnkinnij")
    public suspend fun variableValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableValue = mapped
    }

    internal fun build(): EnvironmentVariableSetupArgs = EnvironmentVariableSetupArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        variableName = variableName ?: throw PulumiNullFieldException("variableName"),
        variableValue = variableValue ?: throw PulumiNullFieldException("variableValue"),
    )
}
