@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetBigDataPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bigDataPoolName Big Data pool name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetBigDataPoolPlainArgs(
    public val bigDataPoolName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetBigDataPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetBigDataPoolPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetBigDataPoolPlainArgs.builder()
            .bigDataPoolName(bigDataPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBigDataPoolPlainArgs].
 */
@PulumiTagMarker
public class GetBigDataPoolPlainArgsBuilder internal constructor() {
    private var bigDataPoolName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Big Data pool name
     */
    @JvmName("plahpgckgfwwijbb")
    public suspend fun bigDataPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bigDataPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jrfuagvpxnmwiguj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ulfhpvhbpjvinpcr")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetBigDataPoolPlainArgs = GetBigDataPoolPlainArgs(
        bigDataPoolName = bigDataPoolName ?: throw PulumiNullFieldException("bigDataPoolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
