@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetIpFirewallRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleName The IP firewall rule name
 * @property workspaceName The name of the workspace.
 */
public data class GetIpFirewallRulePlainArgs(
    public val resourceGroupName: String,
    public val ruleName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetIpFirewallRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetIpFirewallRulePlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetIpFirewallRulePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleName(ruleName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpFirewallRulePlainArgs].
 */
@PulumiTagMarker
public class GetIpFirewallRulePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var ruleName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pihwebodorfnkfwv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The IP firewall rule name
     */
    @JvmName("svqumvawncqejijh")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("adqgyqsaveyrjlrb")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetIpFirewallRulePlainArgs = GetIpFirewallRulePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
