@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetKustoPoolPrincipalAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kustoPoolName The name of the Kusto pool.
 * @property principalAssignmentName The name of the Kusto principalAssignment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetKustoPoolPrincipalAssignmentPlainArgs(
    public val kustoPoolName: String,
    public val principalAssignmentName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetKustoPoolPrincipalAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.GetKustoPoolPrincipalAssignmentPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetKustoPoolPrincipalAssignmentPlainArgs.builder()
            .kustoPoolName(kustoPoolName.let({ args0 -> args0 }))
            .principalAssignmentName(principalAssignmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKustoPoolPrincipalAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetKustoPoolPrincipalAssignmentPlainArgsBuilder internal constructor() {
    private var kustoPoolName: String? = null

    private var principalAssignmentName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("vgksknlaykinpqkn")
    public suspend fun kustoPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("bdrvwpfenimlhrsb")
    public suspend fun principalAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalAssignmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ucfptfrfalwucbcx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("eveeojussihdiocn")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetKustoPoolPrincipalAssignmentPlainArgs =
        GetKustoPoolPrincipalAssignmentPlainArgs(
            kustoPoolName = kustoPoolName ?: throw PulumiNullFieldException("kustoPoolName"),
            principalAssignmentName = principalAssignmentName ?: throw
                PulumiNullFieldException("principalAssignmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
