@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetPrivateLinkHubPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateLinkHubName Name of the privateLinkHub
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrivateLinkHubPlainArgs(
    public val privateLinkHubName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetPrivateLinkHubPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetPrivateLinkHubPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetPrivateLinkHubPlainArgs.builder()
            .privateLinkHubName(privateLinkHubName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateLinkHubPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateLinkHubPlainArgsBuilder internal constructor() {
    private var privateLinkHubName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the privateLinkHub
     */
    @JvmName("wxrnwdsdamcnmfpp")
    public suspend fun privateLinkHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateLinkHubName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("quairdasjcleehtj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateLinkHubPlainArgs = GetPrivateLinkHubPlainArgs(
        privateLinkHubName = privateLinkHubName ?: throw PulumiNullFieldException("privateLinkHubName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
