@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetSqlPoolVulnerabilityAssessmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sqlPoolName SQL pool name
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 * @property workspaceName The name of the workspace.
 */
public data class GetSqlPoolVulnerabilityAssessmentPlainArgs(
    public val resourceGroupName: String,
    public val sqlPoolName: String,
    public val vulnerabilityAssessmentName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetSqlPoolVulnerabilityAssessmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.GetSqlPoolVulnerabilityAssessmentPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetSqlPoolVulnerabilityAssessmentPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName.let({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlPoolVulnerabilityAssessmentPlainArgs].
 */
@PulumiTagMarker
public class GetSqlPoolVulnerabilityAssessmentPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlPoolName: String? = null

    private var vulnerabilityAssessmentName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bjxoinxgdolnhcsm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("wbdvigbrqhyreuyd")
    public suspend fun sqlPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("ucyesqelqtvjmsec")
    public suspend fun vulnerabilityAssessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vulnerabilityAssessmentName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("myxbopjkhvmfbclh")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetSqlPoolVulnerabilityAssessmentPlainArgs =
        GetSqlPoolVulnerabilityAssessmentPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sqlPoolName = sqlPoolName ?: throw PulumiNullFieldException("sqlPoolName"),
            vulnerabilityAssessmentName = vulnerabilityAssessmentName ?: throw
                PulumiNullFieldException("vulnerabilityAssessmentName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
