@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetSqlPoolWorkloadGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sqlPoolName SQL pool name
 * @property workloadGroupName The name of the workload group.
 * @property workspaceName The name of the workspace.
 */
public data class GetSqlPoolWorkloadGroupPlainArgs(
    public val resourceGroupName: String,
    public val sqlPoolName: String,
    public val workloadGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetSqlPoolWorkloadGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetSqlPoolWorkloadGroupPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetSqlPoolWorkloadGroupPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName.let({ args0 -> args0 }))
            .workloadGroupName(workloadGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlPoolWorkloadGroupPlainArgs].
 */
@PulumiTagMarker
public class GetSqlPoolWorkloadGroupPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlPoolName: String? = null

    private var workloadGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xjhfufuhmxsiwada")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("pspsitdwejlqopds")
    public suspend fun sqlPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The name of the workload group.
     */
    @JvmName("uxctkxufuqovcjea")
    public suspend fun workloadGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workloadGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ebfmqflwwxrffcsy")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetSqlPoolWorkloadGroupPlainArgs = GetSqlPoolWorkloadGroupPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlPoolName = sqlPoolName ?: throw PulumiNullFieldException("sqlPoolName"),
        workloadGroupName = workloadGroupName ?: throw PulumiNullFieldException("workloadGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
