@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.KekIdentityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Key encryption key properties
 * @property useSystemAssignedIdentity Boolean specifying whether to use system assigned identity or not
 * @property userAssignedIdentity User assigned identity resource Id
 */
public data class KekIdentityPropertiesArgs(
    public val useSystemAssignedIdentity: Output<Any>? = null,
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.KekIdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.KekIdentityPropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.KekIdentityPropertiesArgs.builder()
            .useSystemAssignedIdentity(useSystemAssignedIdentity?.applyValue({ args0 -> args0 }))
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KekIdentityPropertiesArgs].
 */
@PulumiTagMarker
public class KekIdentityPropertiesArgsBuilder internal constructor() {
    private var useSystemAssignedIdentity: Output<Any>? = null

    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value Boolean specifying whether to use system assigned identity or not
     */
    @JvmName("lgiginqppfcciphm")
    public suspend fun useSystemAssignedIdentity(`value`: Output<Any>) {
        this.useSystemAssignedIdentity = value
    }

    /**
     * @param value User assigned identity resource Id
     */
    @JvmName("iflijeutqevigbyd")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value Boolean specifying whether to use system assigned identity or not
     */
    @JvmName("ueqgtmkmpycorufn")
    public suspend fun useSystemAssignedIdentity(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSystemAssignedIdentity = mapped
    }

    /**
     * @param value User assigned identity resource Id
     */
    @JvmName("suiyiskrmkuuhhgq")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): KekIdentityPropertiesArgs = KekIdentityPropertiesArgs(
        useSystemAssignedIdentity = useSystemAssignedIdentity,
        userAssignedIdentity = userAssignedIdentity,
    )
}
