@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.ManagedIdentityArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The workspace managed identity
 * @property type The type of managed identity for the workspace
 * @property userAssignedIdentities The user assigned managed identities.
 */
public data class ManagedIdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.ManagedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.ManagedIdentityArgs =
        com.pulumi.azurenative.synapse.inputs.ManagedIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedIdentityArgs].
 */
@PulumiTagMarker
public class ManagedIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The type of managed identity for the workspace
     */
    @JvmName("fjpoylemgmtuyomv")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The user assigned managed identities.
     */
    @JvmName("qrytxighuweqgwtq")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("rdioadtohjnwoxed")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The user assigned managed identities.
     */
    @JvmName("rvlvqbrbjcetviks")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The type of managed identity for the workspace
     */
    @JvmName("ofpcgbrpiptnstfr")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user assigned managed identities.
     */
    @JvmName("nndhmchgautcavrb")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The user assigned managed identities.
     */
    @JvmName("nkdtvmbegsjlwoeh")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ManagedIdentityArgs = ManagedIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
