@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SQL pool SKU
 * @property capacity If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
 * @property name The SKU name
 * @property tier The service tier
 */
public data class SkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.SkuArgs =
        com.pulumi.azurenative.synapse.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
     */
    @JvmName("ofxvqtkedhxtppxw")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The SKU name
     */
    @JvmName("biecndtudhyvmcpe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The service tier
     */
    @JvmName("lcavgrdrpgbmjegf")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
     */
    @JvmName("wwdlvducfiiluoop")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The SKU name
     */
    @JvmName("rkywcqubjnrnfcmm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The service tier
     */
    @JvmName("vfdyyrwjlihrynby")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        name = name,
        tier = tier,
    )
}
