@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class representing an attached database configuration.
 * @property attachedDatabaseNames The list of databases from the clusterResourceId which are currently attached to the kusto pool.
 * @property databaseName The name of the database which you would like to attach, use * if you want to follow all current and future databases.
 * @property defaultPrincipalsModificationKind The default principals modification kind
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kustoPoolResourceId The resource id of the kusto pool where the databases you would like to attach reside.
 * @property location Resource location.
 * @property name The name of the resource
 * @property provisioningState The provisioned state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tableLevelSharingProperties Table level sharing specifications
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetKustoPoolAttachedDatabaseConfigurationResult(
    public val attachedDatabaseNames: List<String>,
    public val databaseName: String,
    public val defaultPrincipalsModificationKind: String,
    public val id: String,
    public val kustoPoolResourceId: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tableLevelSharingProperties: TableLevelSharingPropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetKustoPoolAttachedDatabaseConfigurationResult):
            GetKustoPoolAttachedDatabaseConfigurationResult =
            GetKustoPoolAttachedDatabaseConfigurationResult(
                attachedDatabaseNames = javaType.attachedDatabaseNames().map({ args0 -> args0 }),
                databaseName = javaType.databaseName(),
                defaultPrincipalsModificationKind = javaType.defaultPrincipalsModificationKind(),
                id = javaType.id(),
                kustoPoolResourceId = javaType.kustoPoolResourceId(),
                location = javaType.location().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                provisioningState = javaType.provisioningState(),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                tableLevelSharingProperties = javaType.tableLevelSharingProperties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.TableLevelSharingPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
            )
    }
}
