@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The integration runtime authentication keys.
 * @property authKey1 The primary integration runtime authentication key.
 * @property authKey2 The secondary integration runtime authentication key.
 */
public data class ListIntegrationRuntimeAuthKeyResult(
    public val authKey1: String? = null,
    public val authKey2: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.ListIntegrationRuntimeAuthKeyResult):
            ListIntegrationRuntimeAuthKeyResult = ListIntegrationRuntimeAuthKeyResult(
            authKey1 = javaType.authKey1().map({ args0 -> args0 }).orElse(null),
            authKey2 = javaType.authKey2().map({ args0 -> args0 }).orElse(null),
        )
    }
}
