@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * A class that contains the optimized auto scale definition.
 * @property isEnabled A boolean value that indicate if the optimized autoscale feature is enabled or not.
 * @property maximum Maximum allowed instances count.
 * @property minimum Minimum allowed instances count.
 * @property version The version of the template defined, for instance 1.
 */
public data class OptimizedAutoscaleResponse(
    public val isEnabled: Boolean,
    public val maximum: Int,
    public val minimum: Int,
    public val version: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.OptimizedAutoscaleResponse):
            OptimizedAutoscaleResponse = OptimizedAutoscaleResponse(
            isEnabled = javaType.isEnabled(),
            maximum = javaType.maximum(),
            minimum = javaType.minimum(),
            version = javaType.version(),
        )
    }
}
