@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls.
 * @property type Type of the secret.
 * Expected value is 'SecureString'.
 * @property value Value of secure string.
 */
public data class SecureStringResponse(
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.SecureStringResponse):
            SecureStringResponse = SecureStringResponse(
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
