@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Ssis Package.
 * @property description Metadata description.
 * @property folderId Folder id which contains package.
 * @property id Metadata id.
 * @property name Metadata name.
 * @property parameters Parameters in package
 * @property projectId Project id which contains package.
 * @property projectVersion Project version which contains package.
 * @property type The type of SSIS object metadata.
 * Expected value is 'Package'.
 */
public data class SsisPackageResponse(
    public val description: String? = null,
    public val folderId: Double? = null,
    public val id: Double? = null,
    public val name: String? = null,
    public val parameters: List<SsisParameterResponse>? = null,
    public val projectId: Double? = null,
    public val projectVersion: Double? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.SsisPackageResponse):
            SsisPackageResponse = SsisPackageResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            folderId = javaType.folderId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.SsisParameterResponse.Companion.toKotlin(args0)
                })
            }),
            projectId = javaType.projectId().map({ args0 -> args0 }).orElse(null),
            projectVersion = javaType.projectVersion().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
