@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Ssis parameter.
 * @property dataType Parameter type.
 * @property defaultValue Default value of parameter.
 * @property description Parameter description.
 * @property designDefaultValue Design default value of parameter.
 * @property id Parameter id.
 * @property name Parameter name.
 * @property required Whether parameter is required.
 * @property sensitive Whether parameter is sensitive.
 * @property sensitiveDefaultValue Default sensitive value of parameter.
 * @property valueSet Parameter value set.
 * @property valueType Parameter value type.
 * @property variable Parameter reference variable.
 */
public data class SsisParameterResponse(
    public val dataType: String? = null,
    public val defaultValue: String? = null,
    public val description: String? = null,
    public val designDefaultValue: String? = null,
    public val id: Double? = null,
    public val name: String? = null,
    public val required: Boolean? = null,
    public val sensitive: Boolean? = null,
    public val sensitiveDefaultValue: String? = null,
    public val valueSet: Boolean? = null,
    public val valueType: String? = null,
    public val variable: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.SsisParameterResponse):
            SsisParameterResponse = SsisParameterResponse(
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            designDefaultValue = javaType.designDefaultValue().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            required = javaType.required().map({ args0 -> args0 }).orElse(null),
            sensitive = javaType.sensitive().map({ args0 -> args0 }).orElse(null),
            sensitiveDefaultValue = javaType.sensitiveDefaultValue().map({ args0 -> args0 }).orElse(null),
            valueSet = javaType.valueSet().map({ args0 -> args0 }).orElse(null),
            valueType = javaType.valueType().map({ args0 -> args0 }).orElse(null),
            variable = javaType.variable().map({ args0 -> args0 }).orElse(null),
        )
    }
}
