@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Tables that will be included and excluded in the follower database
 * @property externalTablesToExclude List of external tables exclude from the follower database
 * @property externalTablesToInclude List of external tables to include in the follower database
 * @property materializedViewsToExclude List of materialized views exclude from the follower database
 * @property materializedViewsToInclude List of materialized views to include in the follower database
 * @property tablesToExclude List of tables to exclude from the follower database
 * @property tablesToInclude List of tables to include in the follower database
 */
public data class TableLevelSharingPropertiesResponse(
    public val externalTablesToExclude: List<String>? = null,
    public val externalTablesToInclude: List<String>? = null,
    public val materializedViewsToExclude: List<String>? = null,
    public val materializedViewsToInclude: List<String>? = null,
    public val tablesToExclude: List<String>? = null,
    public val tablesToInclude: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.TableLevelSharingPropertiesResponse):
            TableLevelSharingPropertiesResponse = TableLevelSharingPropertiesResponse(
            externalTablesToExclude = javaType.externalTablesToExclude().map({ args0 -> args0 }),
            externalTablesToInclude = javaType.externalTablesToInclude().map({ args0 -> args0 }),
            materializedViewsToExclude = javaType.materializedViewsToExclude().map({ args0 -> args0 }),
            materializedViewsToInclude = javaType.materializedViewsToInclude().map({ args0 -> args0 }),
            tablesToExclude = javaType.tablesToExclude().map({ args0 -> args0 }),
            tablesToInclude = javaType.tablesToInclude().map({ args0 -> args0 }),
        )
    }
}
