@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.kotlin.outputs.PreReleaseAccessRequestSpecResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.testbase.kotlin.outputs.PreReleaseAccessRequestSpecResponse.Companion.toKotlin as preReleaseAccessRequestSpecResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ActionRequest].
 */
@PulumiTagMarker
public class ActionRequestResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActionRequestArgs = ActionRequestArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActionRequestArgsBuilder.() -> Unit) {
        val builder = ActionRequestArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ActionRequest {
        val builtJavaResource = com.pulumi.azurenative.testbase.ActionRequest(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ActionRequest(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### ActionRequestPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var actionRequest = new AzureNative.TestBase.ActionRequest("actionRequest", new()
 *     {
 *         ActionRequestName = "167184141414254",
 *         ResourceGroupName = "contoso-rg",
 *         TestBaseAccountName = "contoso-testBaseAccount",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewActionRequest(ctx, "actionRequest", &testbase.ActionRequestArgs{
 * 			ActionRequestName:   pulumi.String("167184141414254"),
 * 			ResourceGroupName:   pulumi.String("contoso-rg"),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.ActionRequest;
 * import com.pulumi.azurenative.testbase.ActionRequestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var actionRequest = new ActionRequest("actionRequest", ActionRequestArgs.builder()
 *             .actionRequestName("167184141414254")
 *             .resourceGroupName("contoso-rg")
 *             .testBaseAccountName("contoso-testBaseAccount")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:ActionRequest 167184141414254 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/actionRequests/{actionRequestName}
 * ```
 */
public class ActionRequest internal constructor(
    override val javaResource: com.pulumi.azurenative.testbase.ActionRequest,
) : KotlinCustomResource(javaResource, ActionRequestMapper) {
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val preReleaseAccessRequestSpec: Output<PreReleaseAccessRequestSpecResponse>?
        get() = javaResource.preReleaseAccessRequestSpec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> preReleaseAccessRequestSpecResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    public val requestType: Output<String>
        get() = javaResource.requestType().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ActionRequestMapper : ResourceMapper<ActionRequest> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.testbase.ActionRequest::class == javaResource::class

    override fun map(javaResource: Resource): ActionRequest = ActionRequest(
        javaResource as
            com.pulumi.azurenative.testbase.ActionRequest,
    )
}

/**
 * @see [ActionRequest].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ActionRequest].
 */
public suspend fun actionRequest(
    name: String,
    block: suspend ActionRequestResourceBuilder.() -> Unit,
): ActionRequest {
    val builder = ActionRequestResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ActionRequest].
 * @param name The _unique_ name of the resulting resource.
 */
public fun actionRequest(name: String): ActionRequest {
    val builder = ActionRequestResourceBuilder()
    builder.name(name)
    return builder.build()
}
