@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.CredentialArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.CredentialType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The test base credential resource.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### ImageDefinitionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var credential = new AzureNative.TestBase.Credential("credential", new()
 *     {
 *         CredentialName = "contoso-credential",
 *         CredentialType = "IntuneAccount",
 *         DisplayName = "contoso-credential",
 *         ResourceGroupName = "contoso-rg1",
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewCredential(ctx, "credential", &testbase.CredentialArgs{
 * 			CredentialName:      pulumi.String("contoso-credential"),
 * 			CredentialType:      pulumi.String("IntuneAccount"),
 * 			DisplayName:         pulumi.String("contoso-credential"),
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.Credential;
 * import com.pulumi.azurenative.testbase.CredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var credential = new Credential("credential", CredentialArgs.builder()
 *             .credentialName("contoso-credential")
 *             .credentialType("IntuneAccount")
 *             .displayName("contoso-credential")
 *             .resourceGroupName("contoso-rg1")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:Credential contoso-credential /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/credentials/{credentialName}
 * ```
 * @property credentialName The credential resource name.
 * @property credentialType Credential type.
 * @property displayName Credential display name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class CredentialArgs(
    public val credentialName: Output<String>? = null,
    public val credentialType: Output<Either<String, CredentialType>>? = null,
    public val displayName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val testBaseAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.CredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.CredentialArgs =
        com.pulumi.azurenative.testbase.CredentialArgs.builder()
            .credentialName(credentialName?.applyValue({ args0 -> args0 }))
            .credentialType(
                credentialType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CredentialArgs].
 */
@PulumiTagMarker
public class CredentialArgsBuilder internal constructor() {
    private var credentialName: Output<String>? = null

    private var credentialType: Output<Either<String, CredentialType>>? = null

    private var displayName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var testBaseAccountName: Output<String>? = null

    /**
     * @param value The credential resource name.
     */
    @JvmName("nukogqqoyprojqhf")
    public suspend fun credentialName(`value`: Output<String>) {
        this.credentialName = value
    }

    /**
     * @param value Credential type.
     */
    @JvmName("kxxtlgujxielvdmo")
    public suspend fun credentialType(`value`: Output<Either<String, CredentialType>>) {
        this.credentialType = value
    }

    /**
     * @param value Credential display name.
     */
    @JvmName("kodogwufkelcpkio")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gvfvntcwavqbnyqb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("aogsrnanfdeypogo")
    public suspend fun testBaseAccountName(`value`: Output<String>) {
        this.testBaseAccountName = value
    }

    /**
     * @param value The credential resource name.
     */
    @JvmName("vllgamvgabwpjksh")
    public suspend fun credentialName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialName = mapped
    }

    /**
     * @param value Credential type.
     */
    @JvmName("qwuqkqaxgffdjgek")
    public suspend fun credentialType(`value`: Either<String, CredentialType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialType = mapped
    }

    /**
     * @param value Credential type.
     */
    @JvmName("lwijjnnahvnmvqyr")
    public fun credentialType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CredentialType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialType = mapped
    }

    /**
     * @param value Credential type.
     */
    @JvmName("xyootjfveqfwkjna")
    public fun credentialType(`value`: CredentialType) {
        val toBeMapped = Either.ofRight<String, CredentialType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialType = mapped
    }

    /**
     * @param value Credential display name.
     */
    @JvmName("vwkcueaehngmbtcx")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wkvtwtkhvllgsmen")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("fgxktjfpgpdtdxrd")
    public suspend fun testBaseAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBaseAccountName = mapped
    }

    internal fun build(): CredentialArgs = CredentialArgs(
        credentialName = credentialName,
        credentialType = credentialType,
        displayName = displayName,
        resourceGroupName = resourceGroupName,
        testBaseAccountName = testBaseAccountName,
    )
}
