@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.kotlin.outputs.ImageValidationResultsResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.testbase.kotlin.outputs.ImageValidationResultsResponse.Companion.toKotlin as imageValidationResultsResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CustomImage].
 */
@PulumiTagMarker
public class CustomImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomImageArgs = CustomImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomImageArgsBuilder.() -> Unit) {
        val builder = CustomImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomImage {
        val builtJavaResource = com.pulumi.azurenative.testbase.CustomImage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomImage(builtJavaResource)
    }
}

/**
 * The test base custom image resource.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### CustomImageCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customImage = new AzureNative.TestBase.CustomImage("customImage", new()
 *     {
 *         CustomImageName = "image-2cfb2edc-13bc-4d54-8d6e-38b2a233b003",
 *         DefinitionName = "contoso-image-def",
 *         ResourceGroupName = "contoso-rg1",
 *         Source = "VHD",
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *         VersionName = "1.0.0",
 *         VhdId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1/VHDs/vhd-00ac3ccd-1503-4ee5-aa26-26569cfafe88",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewCustomImage(ctx, "customImage", &testbase.CustomImageArgs{
 * 			CustomImageName:     pulumi.String("image-2cfb2edc-13bc-4d54-8d6e-38b2a233b003"),
 * 			DefinitionName:      pulumi.String("contoso-image-def"),
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			Source:              pulumi.String("VHD"),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 			VersionName:         pulumi.String("1.0.0"),
 * 			VhdId:               pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1/VHDs/vhd-00ac3ccd-1503-4ee5-aa26-26569cfafe88"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.CustomImage;
 * import com.pulumi.azurenative.testbase.CustomImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customImage = new CustomImage("customImage", CustomImageArgs.builder()
 *             .customImageName("image-2cfb2edc-13bc-4d54-8d6e-38b2a233b003")
 *             .definitionName("contoso-image-def")
 *             .resourceGroupName("contoso-rg1")
 *             .source("VHD")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .versionName("1.0.0")
 *             .vhdId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1/VHDs/vhd-00ac3ccd-1503-4ee5-aa26-26569cfafe88")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:CustomImage image-2cfb2edc-13bc-4d54-8d6e-38b2a233b003 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/customImages/{customImageName}
 * ```
 */
public class CustomImage internal constructor(
    override val javaResource: com.pulumi.azurenative.testbase.CustomImage,
) : KotlinCustomResource(javaResource, CustomImageMapper) {
    /**
     * The UTC timestamp when the custom image was published.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Image definition name.
     */
    public val definitionName: Output<String>
        get() = javaResource.definitionName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * This property indicates the size of the VHD to be created.
     */
    public val osDiskImageSizeInGB: Output<Double>
        get() = javaResource.osDiskImageSizeInGB().applyValue({ args0 -> args0 })

    /**
     * Product of the custom image.
     */
    public val product: Output<String>
        get() = javaResource.product().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Release of the custom image OS.
     */
    public val release: Output<String>
        get() = javaResource.release().applyValue({ args0 -> args0 })

    /**
     * The release version date of the release of the custom image OS.
     */
    public val releaseVersionDate: Output<String>
        get() = javaResource.releaseVersionDate().applyValue({ args0 -> args0 })

    /**
     * Custom image source type.
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * Status of the custom image.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The validation result of the custom image.
     */
    public val validationResults: Output<ImageValidationResultsResponse>
        get() = javaResource.validationResults().applyValue({ args0 ->
            args0.let({ args0 ->
                imageValidationResultsResponseToKotlin(args0)
            })
        })

    /**
     * Image version name.
     */
    public val versionName: Output<String>
        get() = javaResource.versionName().applyValue({ args0 -> args0 })

    /**
     * The file name of the associated VHD resource.
     */
    public val vhdFileName: Output<String>
        get() = javaResource.vhdFileName().applyValue({ args0 -> args0 })

    /**
     * The Id of the associated VHD resource.
     */
    public val vhdId: Output<String>?
        get() = javaResource.vhdId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object CustomImageMapper : ResourceMapper<CustomImage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.testbase.CustomImage::class == javaResource::class

    override fun map(javaResource: Resource): CustomImage = CustomImage(
        javaResource as
            com.pulumi.azurenative.testbase.CustomImage,
    )
}

/**
 * @see [CustomImage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomImage].
 */
public suspend fun customImage(name: String, block: suspend CustomImageResourceBuilder.() -> Unit):
    CustomImage {
    val builder = CustomImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomImage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customImage(name: String): CustomImage {
    val builder = CustomImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
