@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.kotlin.outputs.NotificationEventReceiverResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.testbase.kotlin.outputs.NotificationEventReceiverResponse.Companion.toKotlin as notificationEventReceiverResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CustomerEvent].
 */
@PulumiTagMarker
public class CustomerEventResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomerEventArgs = CustomerEventArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomerEventArgsBuilder.() -> Unit) {
        val builder = CustomerEventArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomerEvent {
        val builtJavaResource = com.pulumi.azurenative.testbase.CustomerEvent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomerEvent(builtJavaResource)
    }
}

/**
 * The Customer Notification Event resource.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2023-11-01-preview.
 * ## Example Usage
 * ### CustomerEventCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customerEvent = new AzureNative.TestBase.CustomerEvent("customerEvent", new()
 *     {
 *         CustomerEventName = "WeeklySummary",
 *         EventName = "WeeklySummary",
 *         Receivers = new[]
 *         {
 *             new AzureNative.TestBase.Inputs.NotificationEventReceiverArgs
 *             {
 *                 ReceiverType = "UserObjects",
 *                 ReceiverValue = new AzureNative.TestBase.Inputs.NotificationReceiverValueArgs
 *                 {
 *                     UserObjectReceiverValue = new AzureNative.TestBase.Inputs.UserObjectReceiverValueArgs
 *                     {
 *                         UserObjectIds = new[]
 *                         {
 *                             "245245245245325",
 *                             "365365365363565",
 *                         },
 *                     },
 *                 },
 *             },
 *             new AzureNative.TestBase.Inputs.NotificationEventReceiverArgs
 *             {
 *                 ReceiverType = "DistributionGroup",
 *                 ReceiverValue = new AzureNative.TestBase.Inputs.NotificationReceiverValueArgs
 *                 {
 *                     DistributionGroupListReceiverValue = new AzureNative.TestBase.Inputs.DistributionGroupListReceiverValueArgs
 *                     {
 *                         DistributionGroups = new[]
 *                         {
 *                             "test@microsoft.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contoso-rg1",
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewCustomerEvent(ctx, "customerEvent", &testbase.CustomerEventArgs{
 * 			CustomerEventName: pulumi.String("WeeklySummary"),
 * 			EventName:         pulumi.String("WeeklySummary"),
 * 			Receivers: []testbase.NotificationEventReceiverArgs{
 * 				{
 * 					ReceiverType: pulumi.String("UserObjects"),
 * 					ReceiverValue: {
 * 						UserObjectReceiverValue: {
 * 							UserObjectIds: pulumi.StringArray{
 * 								pulumi.String("245245245245325"),
 * 								pulumi.String("365365365363565"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				{
 * 					ReceiverType: pulumi.String("DistributionGroup"),
 * 					ReceiverValue: {
 * 						DistributionGroupListReceiverValue: {
 * 							DistributionGroups: pulumi.StringArray{
 * 								pulumi.String("test@microsoft.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.CustomerEvent;
 * import com.pulumi.azurenative.testbase.CustomerEventArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customerEvent = new CustomerEvent("customerEvent", CustomerEventArgs.builder()
 *             .customerEventName("WeeklySummary")
 *             .eventName("WeeklySummary")
 *             .receivers(
 *                 Map.ofEntries(
 *                     Map.entry("receiverType", "UserObjects"),
 *                     Map.entry("receiverValue", Map.of("userObjectReceiverValue", Map.of("userObjectIds",
 *                         "245245245245325",
 *                         "365365365363565")))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("receiverType", "DistributionGroup"),
 *                     Map.entry("receiverValue", Map.of("distributionGroupListReceiverValue", Map.of("distributionGroups", "test@microsoft.com")))
 *                 ))
 *             .resourceGroupName("contoso-rg1")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:CustomerEvent WeeklySummary /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/customerEvents/{customerEventName}
 * ```
 */
public class CustomerEvent internal constructor(
    override val javaResource: com.pulumi.azurenative.testbase.CustomerEvent,
) : KotlinCustomResource(javaResource, CustomerEventMapper) {
    /**
     * The name of the event subscribed to.
     */
    public val eventName: Output<String>
        get() = javaResource.eventName().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The notification event receivers.
     */
    public val receivers: Output<List<NotificationEventReceiverResponse>>
        get() = javaResource.receivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    notificationEventReceiverResponseToKotlin(args0)
                })
            })
        })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomerEventMapper : ResourceMapper<CustomerEvent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.testbase.CustomerEvent::class == javaResource::class

    override fun map(javaResource: Resource): CustomerEvent = CustomerEvent(
        javaResource as
            com.pulumi.azurenative.testbase.CustomerEvent,
    )
}

/**
 * @see [CustomerEvent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomerEvent].
 */
public suspend fun customerEvent(
    name: String,
    block: suspend CustomerEventResourceBuilder.() -> Unit,
): CustomerEvent {
    val builder = CustomerEventResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomerEvent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customerEvent(name: String): CustomerEvent {
    val builder = CustomerEventResourceBuilder()
    builder.name(name)
    return builder.build()
}
