@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Custom image source type.
 */
public enum class ImageSource(
    public val javaValue: com.pulumi.azurenative.testbase.enums.ImageSource,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.enums.ImageSource> {
    /**
     * Unknown image source type.
     */
    Unknown(com.pulumi.azurenative.testbase.enums.ImageSource.Unknown),

    /**
     * Specify image onboarding through VHD.
     */
    VHD(com.pulumi.azurenative.testbase.enums.ImageSource.VHD),
    ;

    override fun toJava(): com.pulumi.azurenative.testbase.enums.ImageSource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.enums.ImageSource): ImageSource =
            ImageSource.values().first { it.javaValue == javaType }
    }
}
