@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetImageDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property imageDefinitionName The resource name of the test base image definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class GetImageDefinitionPlainArgs(
    public val imageDefinitionName: String,
    public val resourceGroupName: String,
    public val testBaseAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetImageDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.GetImageDefinitionPlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetImageDefinitionPlainArgs.builder()
            .imageDefinitionName(imageDefinitionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImageDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetImageDefinitionPlainArgsBuilder internal constructor() {
    private var imageDefinitionName: String? = null

    private var resourceGroupName: String? = null

    private var testBaseAccountName: String? = null

    /**
     * @param value The resource name of the test base image definition.
     */
    @JvmName("qmtxiotodlpbpaec")
    public suspend fun imageDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.imageDefinitionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sbrnrdrswmudfyxq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("dphrnwtgylecviao")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    internal fun build(): GetImageDefinitionPlainArgs = GetImageDefinitionPlainArgs(
        imageDefinitionName = imageDefinitionName ?: throw PulumiNullFieldException("imageDefinitionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
    )
}
