@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetTestBaseAccountFileUploadUrlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blobName The custom file name of the uploaded blob.
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class GetTestBaseAccountFileUploadUrlPlainArgs(
    public val blobName: String? = null,
    public val resourceGroupName: String,
    public val testBaseAccountName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetTestBaseAccountFileUploadUrlPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.testbase.inputs.GetTestBaseAccountFileUploadUrlPlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetTestBaseAccountFileUploadUrlPlainArgs.builder()
            .blobName(blobName?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTestBaseAccountFileUploadUrlPlainArgs].
 */
@PulumiTagMarker
public class GetTestBaseAccountFileUploadUrlPlainArgsBuilder internal constructor() {
    private var blobName: String? = null

    private var resourceGroupName: String? = null

    private var testBaseAccountName: String? = null

    /**
     * @param value The custom file name of the uploaded blob.
     */
    @JvmName("kvjkhliguemwplql")
    public suspend fun blobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.blobName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("fvalbhkdqxfswuug")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("fwgraxwjwbdcqwky")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    internal fun build(): GetTestBaseAccountFileUploadUrlPlainArgs =
        GetTestBaseAccountFileUploadUrlPlainArgs(
            blobName = blobName,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
        )
}
