@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.HighlightedFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The information of a highlighted file that user should pay attention to.
 * @property path The path of the highlighted file.
 * @property sections The name of sections to highlight.
 * @property visited A flag to save whether this file is viewed by user.
 */
public data class HighlightedFileArgs(
    public val path: Output<String>,
    public val sections: Output<List<String>>? = null,
    public val visited: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.HighlightedFileArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.HighlightedFileArgs =
        com.pulumi.azurenative.testbase.inputs.HighlightedFileArgs.builder()
            .path(path.applyValue({ args0 -> args0 }))
            .sections(sections?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .visited(visited?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HighlightedFileArgs].
 */
@PulumiTagMarker
public class HighlightedFileArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var sections: Output<List<String>>? = null

    private var visited: Output<Boolean>? = null

    /**
     * @param value The path of the highlighted file.
     */
    @JvmName("ouqrikyogwmpaeyr")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The name of sections to highlight.
     */
    @JvmName("eqilpuqkgjoymuue")
    public suspend fun sections(`value`: Output<List<String>>) {
        this.sections = value
    }

    @JvmName("ccvopvcrdfexywxm")
    public suspend fun sections(vararg values: Output<String>) {
        this.sections = Output.all(values.asList())
    }

    /**
     * @param values The name of sections to highlight.
     */
    @JvmName("bccnhlmrynstjcgg")
    public suspend fun sections(values: List<Output<String>>) {
        this.sections = Output.all(values)
    }

    /**
     * @param value A flag to save whether this file is viewed by user.
     */
    @JvmName("duivpnydoqwyblkt")
    public suspend fun visited(`value`: Output<Boolean>) {
        this.visited = value
    }

    /**
     * @param value The path of the highlighted file.
     */
    @JvmName("gnfaknpvrlcifckj")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The name of sections to highlight.
     */
    @JvmName("acvwebblnutqqhpd")
    public suspend fun sections(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sections = mapped
    }

    /**
     * @param values The name of sections to highlight.
     */
    @JvmName("firsjtfphnrdhstk")
    public suspend fun sections(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sections = mapped
    }

    /**
     * @param value A flag to save whether this file is viewed by user.
     */
    @JvmName("jvhrsiipenbbeisp")
    public suspend fun visited(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visited = mapped
    }

    internal fun build(): HighlightedFileArgs = HighlightedFileArgs(
        path = path ?: throw PulumiNullFieldException("path"),
        sections = sections,
        visited = visited,
    )
}
