@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.NotificationReceiverValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A notification event receiver value.
 * @property distributionGroupListReceiverValue The user object receiver value.
 * @property subscriptionReceiverValue The user object receiver value.
 * @property userObjectReceiverValue The user object receiver value.
 */
public data class NotificationReceiverValueArgs(
    public val distributionGroupListReceiverValue: Output<DistributionGroupListReceiverValueArgs>? =
        null,
    public val subscriptionReceiverValue: Output<SubscriptionReceiverValueArgs>? = null,
    public val userObjectReceiverValue: Output<UserObjectReceiverValueArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.NotificationReceiverValueArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.NotificationReceiverValueArgs =
        com.pulumi.azurenative.testbase.inputs.NotificationReceiverValueArgs.builder()
            .distributionGroupListReceiverValue(
                distributionGroupListReceiverValue?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .subscriptionReceiverValue(
                subscriptionReceiverValue?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userObjectReceiverValue(
                userObjectReceiverValue?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NotificationReceiverValueArgs].
 */
@PulumiTagMarker
public class NotificationReceiverValueArgsBuilder internal constructor() {
    private var distributionGroupListReceiverValue: Output<DistributionGroupListReceiverValueArgs>? =
        null

    private var subscriptionReceiverValue: Output<SubscriptionReceiverValueArgs>? = null

    private var userObjectReceiverValue: Output<UserObjectReceiverValueArgs>? = null

    /**
     * @param value The user object receiver value.
     */
    @JvmName("xliebssyiiovgdks")
    public suspend
    fun distributionGroupListReceiverValue(`value`: Output<DistributionGroupListReceiverValueArgs>) {
        this.distributionGroupListReceiverValue = value
    }

    /**
     * @param value The user object receiver value.
     */
    @JvmName("rvbqtknoskpxfcel")
    public suspend fun subscriptionReceiverValue(`value`: Output<SubscriptionReceiverValueArgs>) {
        this.subscriptionReceiverValue = value
    }

    /**
     * @param value The user object receiver value.
     */
    @JvmName("wkumswbgfexbuaay")
    public suspend fun userObjectReceiverValue(`value`: Output<UserObjectReceiverValueArgs>) {
        this.userObjectReceiverValue = value
    }

    /**
     * @param value The user object receiver value.
     */
    @JvmName("eeoaflmnjiwsddck")
    public suspend
    fun distributionGroupListReceiverValue(`value`: DistributionGroupListReceiverValueArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributionGroupListReceiverValue = mapped
    }

    /**
     * @param argument The user object receiver value.
     */
    @JvmName("vvwdbpaaghnovegg")
    public suspend
    fun distributionGroupListReceiverValue(argument: suspend DistributionGroupListReceiverValueArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionGroupListReceiverValueArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.distributionGroupListReceiverValue = mapped
    }

    /**
     * @param value The user object receiver value.
     */
    @JvmName("lgwmojgrnqqydhjo")
    public suspend fun subscriptionReceiverValue(`value`: SubscriptionReceiverValueArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionReceiverValue = mapped
    }

    /**
     * @param argument The user object receiver value.
     */
    @JvmName("xlcvdlfjyeldwttg")
    public suspend
    fun subscriptionReceiverValue(argument: suspend SubscriptionReceiverValueArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriptionReceiverValueArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subscriptionReceiverValue = mapped
    }

    /**
     * @param value The user object receiver value.
     */
    @JvmName("obdkpcepeyomsdhr")
    public suspend fun userObjectReceiverValue(`value`: UserObjectReceiverValueArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userObjectReceiverValue = mapped
    }

    /**
     * @param argument The user object receiver value.
     */
    @JvmName("wwqxkqkkeuhqxxhy")
    public suspend
    fun userObjectReceiverValue(argument: suspend UserObjectReceiverValueArgsBuilder.() -> Unit) {
        val toBeMapped = UserObjectReceiverValueArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userObjectReceiverValue = mapped
    }

    internal fun build(): NotificationReceiverValueArgs = NotificationReceiverValueArgs(
        distributionGroupListReceiverValue = distributionGroupListReceiverValue,
        subscriptionReceiverValue = subscriptionReceiverValue,
        userObjectReceiverValue = userObjectReceiverValue,
    )
}
