@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.TargetOSInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The information of the target OS to be tested.
 * @property baselineOSs Specifies the baseline OSs to be tested.
 * @property insiderChannelIds Insider Channel Ids. Only used for feature update.
 * @property osUpdateType Specifies the OS update type to test against, e.g., 'Security updates' or 'Feature updates'.
 * @property targetOSImageIds Specifies the ids of the target OSs from Custom Images to be tested.
 * @property targetOSs Specifies the target OSs to be tested.
 */
public data class TargetOSInfoArgs(
    public val baselineOSs: Output<List<String>>? = null,
    public val insiderChannelIds: Output<List<String>>? = null,
    public val osUpdateType: Output<String>,
    public val targetOSImageIds: Output<List<String>>? = null,
    public val targetOSs: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.TargetOSInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.TargetOSInfoArgs =
        com.pulumi.azurenative.testbase.inputs.TargetOSInfoArgs.builder()
            .baselineOSs(baselineOSs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .insiderChannelIds(insiderChannelIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .osUpdateType(osUpdateType.applyValue({ args0 -> args0 }))
            .targetOSImageIds(targetOSImageIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetOSs(targetOSs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TargetOSInfoArgs].
 */
@PulumiTagMarker
public class TargetOSInfoArgsBuilder internal constructor() {
    private var baselineOSs: Output<List<String>>? = null

    private var insiderChannelIds: Output<List<String>>? = null

    private var osUpdateType: Output<String>? = null

    private var targetOSImageIds: Output<List<String>>? = null

    private var targetOSs: Output<List<String>>? = null

    /**
     * @param value Specifies the baseline OSs to be tested.
     */
    @JvmName("ievbfqugragwjyys")
    public suspend fun baselineOSs(`value`: Output<List<String>>) {
        this.baselineOSs = value
    }

    @JvmName("emibfiruuejxsfys")
    public suspend fun baselineOSs(vararg values: Output<String>) {
        this.baselineOSs = Output.all(values.asList())
    }

    /**
     * @param values Specifies the baseline OSs to be tested.
     */
    @JvmName("axtobbfvhjdggdwu")
    public suspend fun baselineOSs(values: List<Output<String>>) {
        this.baselineOSs = Output.all(values)
    }

    /**
     * @param value Insider Channel Ids. Only used for feature update.
     */
    @JvmName("srhuijjgnlnwdmsf")
    public suspend fun insiderChannelIds(`value`: Output<List<String>>) {
        this.insiderChannelIds = value
    }

    @JvmName("wdperbhihcteimmr")
    public suspend fun insiderChannelIds(vararg values: Output<String>) {
        this.insiderChannelIds = Output.all(values.asList())
    }

    /**
     * @param values Insider Channel Ids. Only used for feature update.
     */
    @JvmName("usuwckqfsoewbxje")
    public suspend fun insiderChannelIds(values: List<Output<String>>) {
        this.insiderChannelIds = Output.all(values)
    }

    /**
     * @param value Specifies the OS update type to test against, e.g., 'Security updates' or 'Feature updates'.
     */
    @JvmName("pcacybvnljtcpprp")
    public suspend fun osUpdateType(`value`: Output<String>) {
        this.osUpdateType = value
    }

    /**
     * @param value Specifies the ids of the target OSs from Custom Images to be tested.
     */
    @JvmName("wgditeukyhxjyygh")
    public suspend fun targetOSImageIds(`value`: Output<List<String>>) {
        this.targetOSImageIds = value
    }

    @JvmName("pkhkrdndwieupmfj")
    public suspend fun targetOSImageIds(vararg values: Output<String>) {
        this.targetOSImageIds = Output.all(values.asList())
    }

    /**
     * @param values Specifies the ids of the target OSs from Custom Images to be tested.
     */
    @JvmName("kkuotvqpnaliacgw")
    public suspend fun targetOSImageIds(values: List<Output<String>>) {
        this.targetOSImageIds = Output.all(values)
    }

    /**
     * @param value Specifies the target OSs to be tested.
     */
    @JvmName("jqhatylavukioduy")
    public suspend fun targetOSs(`value`: Output<List<String>>) {
        this.targetOSs = value
    }

    @JvmName("myjlckjfrliarpos")
    public suspend fun targetOSs(vararg values: Output<String>) {
        this.targetOSs = Output.all(values.asList())
    }

    /**
     * @param values Specifies the target OSs to be tested.
     */
    @JvmName("hgusiswnrehqmphy")
    public suspend fun targetOSs(values: List<Output<String>>) {
        this.targetOSs = Output.all(values)
    }

    /**
     * @param value Specifies the baseline OSs to be tested.
     */
    @JvmName("dyvdrxxybnfeqmkk")
    public suspend fun baselineOSs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineOSs = mapped
    }

    /**
     * @param values Specifies the baseline OSs to be tested.
     */
    @JvmName("oakglgofdltemwgj")
    public suspend fun baselineOSs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baselineOSs = mapped
    }

    /**
     * @param value Insider Channel Ids. Only used for feature update.
     */
    @JvmName("aiqsboukirqijpts")
    public suspend fun insiderChannelIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insiderChannelIds = mapped
    }

    /**
     * @param values Insider Channel Ids. Only used for feature update.
     */
    @JvmName("ecgolaiypvsqafna")
    public suspend fun insiderChannelIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insiderChannelIds = mapped
    }

    /**
     * @param value Specifies the OS update type to test against, e.g., 'Security updates' or 'Feature updates'.
     */
    @JvmName("evshbqpbygodaknv")
    public suspend fun osUpdateType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osUpdateType = mapped
    }

    /**
     * @param value Specifies the ids of the target OSs from Custom Images to be tested.
     */
    @JvmName("ecouvbwctxveaeun")
    public suspend fun targetOSImageIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOSImageIds = mapped
    }

    /**
     * @param values Specifies the ids of the target OSs from Custom Images to be tested.
     */
    @JvmName("ydqqqnwrxswaphdp")
    public suspend fun targetOSImageIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetOSImageIds = mapped
    }

    /**
     * @param value Specifies the target OSs to be tested.
     */
    @JvmName("kxovntmvpqudjcau")
    public suspend fun targetOSs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOSs = mapped
    }

    /**
     * @param values Specifies the target OSs to be tested.
     */
    @JvmName("pacbtqvucblrxlew")
    public suspend fun targetOSs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetOSs = mapped
    }

    internal fun build(): TargetOSInfoArgs = TargetOSInfoArgs(
        baselineOSs = baselineOSs,
        insiderChannelIds = insiderChannelIds,
        osUpdateType = osUpdateType ?: throw PulumiNullFieldException("osUpdateType"),
        targetOSImageIds = targetOSImageIds,
        targetOSs = targetOSs,
    )
}
