@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property applicationName
 * @property applicationVersion
 * @property azureResourceUri
 * @property totalCharges
 * @property totalUsedBillableHours
 * @property totalUsedFreeHours
 * @property usageEntriesGroupedByUpdateType
 */
public data class BillingHubPackageUsageResponse(
    public val applicationName: String? = null,
    public val applicationVersion: String? = null,
    public val azureResourceUri: String? = null,
    public val totalCharges: Double? = null,
    public val totalUsedBillableHours: Double? = null,
    public val totalUsedFreeHours: Double? = null,
    public val usageEntriesGroupedByUpdateType: List<BillingHubUsageGroupedByUpdateTypeResponse>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.BillingHubPackageUsageResponse):
            BillingHubPackageUsageResponse = BillingHubPackageUsageResponse(
            applicationName = javaType.applicationName().map({ args0 -> args0 }).orElse(null),
            applicationVersion = javaType.applicationVersion().map({ args0 -> args0 }).orElse(null),
            azureResourceUri = javaType.azureResourceUri().map({ args0 -> args0 }).orElse(null),
            totalCharges = javaType.totalCharges().map({ args0 -> args0 }).orElse(null),
            totalUsedBillableHours = javaType.totalUsedBillableHours().map({ args0 -> args0 }).orElse(null),
            totalUsedFreeHours = javaType.totalUsedFreeHours().map({ args0 -> args0 }).orElse(null),
            usageEntriesGroupedByUpdateType = javaType.usageEntriesGroupedByUpdateType().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.BillingHubUsageGroupedByUpdateTypeResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
