@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Double
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property nextRequest
 * @property packageUsageEntries
 * @property totalCharges
 * @property totalUsedBillableHours
 * @property totalUsedFreeHours
 */
public data class GetBillingHubServiceUsageResult(
    public val nextRequest: BillingHubGetUsageRequestResponse? = null,
    public val packageUsageEntries: List<BillingHubPackageUsageResponse>? = null,
    public val totalCharges: Double? = null,
    public val totalUsedBillableHours: Double? = null,
    public val totalUsedFreeHours: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetBillingHubServiceUsageResult):
            GetBillingHubServiceUsageResult = GetBillingHubServiceUsageResult(
            nextRequest = javaType.nextRequest().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.BillingHubGetUsageRequestResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            packageUsageEntries = javaType.packageUsageEntries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.BillingHubPackageUsageResponse.Companion.toKotlin(args0)
                })
            }),
            totalCharges = javaType.totalCharges().map({ args0 -> args0 }).orElse(null),
            totalUsedBillableHours = javaType.totalUsedBillableHours().map({ args0 -> args0 }).orElse(null),
            totalUsedFreeHours = javaType.totalUsedFreeHours().map({ args0 -> args0 }).orElse(null),
        )
    }
}
