@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.EnvironmentStatusResponse
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.Gen2StorageConfigurationOutputResponse
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.TimeSeriesIdPropertyResponse
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.WarmStoreConfigurationPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.EnvironmentStatusResponse.Companion.toKotlin as environmentStatusResponseToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.Gen2StorageConfigurationOutputResponse.Companion.toKotlin as gen2StorageConfigurationOutputResponseToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.TimeSeriesIdPropertyResponse.Companion.toKotlin as timeSeriesIdPropertyResponseToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.WarmStoreConfigurationPropertiesResponse.Companion.toKotlin as warmStoreConfigurationPropertiesResponseToKotlin

/**
 * Builder for [Gen2Environment].
 */
@PulumiTagMarker
public class Gen2EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: Gen2EnvironmentArgs = Gen2EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend Gen2EnvironmentArgsBuilder.() -> Unit) {
        val builder = Gen2EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Gen2Environment {
        val builtJavaResource =
            com.pulumi.azurenative.timeseriesinsights.Gen2Environment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Gen2Environment(builtJavaResource)
    }
}

/**
 * An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen2 environments do not have set data retention limits.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * ## Example Usage
 * ### EnvironmentsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gen2Environment = new AzureNative.TimeSeriesInsights.Gen2Environment("gen2Environment", new()
 *     {
 *         EnvironmentName = "env1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewGen2Environment(ctx, "gen2Environment", &timeseriesinsights.Gen2EnvironmentArgs{
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.Gen2Environment;
 * import com.pulumi.azurenative.timeseriesinsights.Gen2EnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gen2Environment = new Gen2Environment("gen2Environment", Gen2EnvironmentArgs.builder()
 *             .environmentName("env1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:Gen2Environment env1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}
 * ```
 */
public class Gen2Environment internal constructor(
    override val javaResource: com.pulumi.azurenative.timeseriesinsights.Gen2Environment,
) : KotlinCustomResource(javaResource, Gen2EnvironmentMapper) {
    /**
     * The time the resource was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The fully qualified domain name used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
     */
    public val dataAccessFqdn: Output<String>
        get() = javaResource.dataAccessFqdn().applyValue({ args0 -> args0 })

    /**
     * An id used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
     */
    public val dataAccessId: Output<String>
        get() = javaResource.dataAccessId().applyValue({ args0 -> args0 })

    /**
     * The kind of the environment.
     * Expected value is 'Gen2'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * An object that represents the status of the environment, and its internal state in the Time Series Insights service.
     */
    public val status: Output<EnvironmentStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                environmentStatusResponseToKotlin(args0)
            })
        })

    /**
     * The storage configuration provides the connection details that allows the Time Series Insights service to connect to the customer storage account that is used to store the environment's data.
     */
    public val storageConfiguration: Output<Gen2StorageConfigurationOutputResponse>
        get() = javaResource.storageConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                gen2StorageConfigurationOutputResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The list of event properties which will be used to define the environment's time series id.
     */
    public val timeSeriesIdProperties: Output<List<TimeSeriesIdPropertyResponse>>
        get() = javaResource.timeSeriesIdProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeSeriesIdPropertyResponseToKotlin(args0) })
            })
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's data available for faster query.
     */
    public val warmStoreConfiguration: Output<WarmStoreConfigurationPropertiesResponse>?
        get() = javaResource.warmStoreConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    warmStoreConfigurationPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object Gen2EnvironmentMapper : ResourceMapper<Gen2Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.timeseriesinsights.Gen2Environment::class == javaResource::class

    override fun map(javaResource: Resource): Gen2Environment = Gen2Environment(
        javaResource as
            com.pulumi.azurenative.timeseriesinsights.Gen2Environment,
    )
}

/**
 * @see [Gen2Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gen2Environment].
 */
public suspend fun gen2Environment(
    name: String,
    block: suspend Gen2EnvironmentResourceBuilder.() -> Unit,
): Gen2Environment {
    val builder = Gen2EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gen2Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gen2Environment(name: String): Gen2Environment {
    val builder = Gen2EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
