@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.GetGen2EnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName The name of the Time Series Insights environment associated with the specified resource group.
 * @property expand Setting $expand=status will include the status of the internal services of the environment in the Time Series Insights service.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetGen2EnvironmentPlainArgs(
    public val environmentName: String,
    public val expand: String? = null,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.GetGen2EnvironmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.timeseriesinsights.inputs.GetGen2EnvironmentPlainArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.GetGen2EnvironmentPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGen2EnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetGen2EnvironmentPlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var expand: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("usgwdfxevrddgphm")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Setting $expand=status will include the status of the internal services of the environment in the Time Series Insights service.
     */
    @JvmName("lbbmknwpmpipgvaa")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("oekjpldlhfwrhuic")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGen2EnvironmentPlainArgs = GetGen2EnvironmentPlainArgs(
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
