@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.TimeSeriesIdPropertyArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.enums.PropertyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The structure of the property that a time series id can have. An environment can have multiple such properties.
 * @property name The name of the property.
 * @property type The type of the property.
 */
public data class TimeSeriesIdPropertyArgs(
    public val name: Output<String>? = null,
    public val type: Output<Either<String, PropertyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.TimeSeriesIdPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.inputs.TimeSeriesIdPropertyArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.TimeSeriesIdPropertyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TimeSeriesIdPropertyArgs].
 */
@PulumiTagMarker
public class TimeSeriesIdPropertyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, PropertyType>>? = null

    /**
     * @param value The name of the property.
     */
    @JvmName("mskjwpsthfrvfytm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the property.
     */
    @JvmName("wylxihenouvpqivk")
    public suspend fun type(`value`: Output<Either<String, PropertyType>>) {
        this.type = value
    }

    /**
     * @param value The name of the property.
     */
    @JvmName("qhonphbfirvugmbt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of the property.
     */
    @JvmName("nbxobjndqjqincek")
    public suspend fun type(`value`: Either<String, PropertyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the property.
     */
    @JvmName("itfnyjjdusabllaa")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the property.
     */
    @JvmName("lidttxhfkjdsirpr")
    public fun type(`value`: PropertyType) {
        val toBeMapped = Either.ofRight<String, PropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TimeSeriesIdPropertyArgs = TimeSeriesIdPropertyArgs(
        name = name,
        type = type,
    )
}
