@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen2 environments do not have set data retention limits.
 * @property creationTime The time the resource was created.
 * @property dataAccessFqdn The fully qualified domain name used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
 * @property dataAccessId An id used to access the environment data, e.g. to query the environment's events or upload reference data for the environment.
 * @property id Resource Id
 * @property kind The kind of the environment.
 * Expected value is 'Gen2'.
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState Provisioning state of the resource.
 * @property sku The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
 * @property status An object that represents the status of the environment, and its internal state in the Time Series Insights service.
 * @property storageConfiguration The storage configuration provides the connection details that allows the Time Series Insights service to connect to the customer storage account that is used to store the environment's data.
 * @property tags Resource tags
 * @property timeSeriesIdProperties The list of event properties which will be used to define the environment's time series id.
 * @property type Resource type
 * @property warmStoreConfiguration The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's data available for faster query.
 */
public data class GetGen2EnvironmentResult(
    public val creationTime: String,
    public val dataAccessFqdn: String,
    public val dataAccessId: String,
    public val id: String,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sku: SkuResponse,
    public val status: EnvironmentStatusResponse,
    public val storageConfiguration: Gen2StorageConfigurationOutputResponse,
    public val tags: Map<String, String>? = null,
    public val timeSeriesIdProperties: List<TimeSeriesIdPropertyResponse>,
    public val type: String,
    public val warmStoreConfiguration: WarmStoreConfigurationPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.GetGen2EnvironmentResult):
            GetGen2EnvironmentResult = GetGen2EnvironmentResult(
            creationTime = javaType.creationTime(),
            dataAccessFqdn = javaType.dataAccessFqdn(),
            dataAccessId = javaType.dataAccessId(),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.EnvironmentStatusResponse.Companion.toKotlin(args0)
            }),
            storageConfiguration = javaType.storageConfiguration().let({ args0 ->
                com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.Gen2StorageConfigurationOutputResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeSeriesIdProperties = javaType.timeSeriesIdProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.TimeSeriesIdPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            warmStoreConfiguration = javaType.warmStoreConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.WarmStoreConfigurationPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
