@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EdgeModule].
 */
@PulumiTagMarker
public class EdgeModuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EdgeModuleArgs = EdgeModuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EdgeModuleArgsBuilder.() -> Unit) {
        val builder = EdgeModuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EdgeModule {
        val builtJavaResource = com.pulumi.azurenative.videoanalyzer.EdgeModule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EdgeModule(builtJavaResource)
    }
}

/**
 * The representation of an edge module.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * ## Example Usage
 * ### Registers an edge module.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var edgeModule = new AzureNative.VideoAnalyzer.EdgeModule("edgeModule", new()
 *     {
 *         AccountName = "testaccount2",
 *         EdgeModuleName = "edgeModule1",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewEdgeModule(ctx, "edgeModule", &videoanalyzer.EdgeModuleArgs{
 * 			AccountName:       pulumi.String("testaccount2"),
 * 			EdgeModuleName:    pulumi.String("edgeModule1"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.EdgeModule;
 * import com.pulumi.azurenative.videoanalyzer.EdgeModuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var edgeModule = new EdgeModule("edgeModule", EdgeModuleArgs.builder()
 *             .accountName("testaccount2")
 *             .edgeModuleName("edgeModule1")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:EdgeModule edgeModule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/edgeModules/{edgeModuleName}
 * ```
 */
public class EdgeModule internal constructor(
    override val javaResource: com.pulumi.azurenative.videoanalyzer.EdgeModule,
) : KotlinCustomResource(javaResource, EdgeModuleMapper) {
    /**
     * Internal ID generated for the instance of the Video Analyzer edge module.
     */
    public val edgeModuleId: Output<String>
        get() = javaResource.edgeModuleId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EdgeModuleMapper : ResourceMapper<EdgeModule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.videoanalyzer.EdgeModule::class == javaResource::class

    override fun map(javaResource: Resource): EdgeModule = EdgeModule(
        javaResource as
            com.pulumi.azurenative.videoanalyzer.EdgeModule,
    )
}

/**
 * @see [EdgeModule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EdgeModule].
 */
public suspend fun edgeModule(name: String, block: suspend EdgeModuleResourceBuilder.() -> Unit):
    EdgeModule {
    val builder = EdgeModuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EdgeModule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun edgeModule(name: String): EdgeModule {
    val builder = EdgeModuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
