@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.LivePipelineArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.ParameterDefinitionArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.ParameterDefinitionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Live pipeline represents a unique instance of a live topology, used for real-time ingestion, archiving and publishing of content for a unique RTSP camera.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * ## Example Usage
 * ### Create or update a live pipeline
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var livePipeline = new AzureNative.VideoAnalyzer.LivePipeline("livePipeline", new()
 *     {
 *         AccountName = "testaccount2",
 *         BitrateKbps = 500,
 *         Description = "Live Pipeline 1 Description",
 *         LivePipelineName = "livePipeline1",
 *         Parameters = new[]
 *         {
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDefinitionArgs
 *             {
 *                 Name = "rtspUrlParameter",
 *                 Value = "rtsp://contoso.com/stream",
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         TopologyName = "pipelinetopology1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewLivePipeline(ctx, "livePipeline", &videoanalyzer.LivePipelineArgs{
 * 			AccountName:      pulumi.String("testaccount2"),
 * 			BitrateKbps:      pulumi.Int(500),
 * 			Description:      pulumi.String("Live Pipeline 1 Description"),
 * 			LivePipelineName: pulumi.String("livePipeline1"),
 * 			Parameters: []videoanalyzer.ParameterDefinitionArgs{
 * 				{
 * 					Name:  pulumi.String("rtspUrlParameter"),
 * 					Value: pulumi.String("rtsp://contoso.com/stream"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			TopologyName:      pulumi.String("pipelinetopology1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.LivePipeline;
 * import com.pulumi.azurenative.videoanalyzer.LivePipelineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var livePipeline = new LivePipeline("livePipeline", LivePipelineArgs.builder()
 *             .accountName("testaccount2")
 *             .bitrateKbps(500)
 *             .description("Live Pipeline 1 Description")
 *             .livePipelineName("livePipeline1")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("name", "rtspUrlParameter"),
 *                 Map.entry("value", "rtsp://contoso.com/stream")
 *             ))
 *             .resourceGroupName("testrg")
 *             .topologyName("pipelinetopology1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:LivePipeline livePipeline1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/livePipelines/{livePipelineName}
 * ```
 * @property accountName The Azure Video Analyzer account name.
 * @property bitrateKbps Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to see if the camera bitrate is now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
 * @property description An optional description for the pipeline.
 * @property livePipelineName Live pipeline unique identifier.
 * @property parameters List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property topologyName The reference to an existing pipeline topology defined for real-time content processing. When activated, this live pipeline will process content according to the pipeline topology definition.
 */
public data class LivePipelineArgs(
    public val accountName: Output<String>? = null,
    public val bitrateKbps: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val livePipelineName: Output<String>? = null,
    public val parameters: Output<List<ParameterDefinitionArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val topologyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.LivePipelineArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.LivePipelineArgs =
        com.pulumi.azurenative.videoanalyzer.LivePipelineArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .bitrateKbps(bitrateKbps?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .livePipelineName(livePipelineName?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .topologyName(topologyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LivePipelineArgs].
 */
@PulumiTagMarker
public class LivePipelineArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var bitrateKbps: Output<Int>? = null

    private var description: Output<String>? = null

    private var livePipelineName: Output<String>? = null

    private var parameters: Output<List<ParameterDefinitionArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var topologyName: Output<String>? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("rkgpxsuxnemvsdxp")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to see if the camera bitrate is now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
     */
    @JvmName("tunnatldphbaijll")
    public suspend fun bitrateKbps(`value`: Output<Int>) {
        this.bitrateKbps = value
    }

    /**
     * @param value An optional description for the pipeline.
     */
    @JvmName("qllnlrpvhkqeeyhu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Live pipeline unique identifier.
     */
    @JvmName("jslbfynyjutjarga")
    public suspend fun livePipelineName(`value`: Output<String>) {
        this.livePipelineName = value
    }

    /**
     * @param value List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("wwpgiwuerhanflwn")
    public suspend fun parameters(`value`: Output<List<ParameterDefinitionArgs>>) {
        this.parameters = value
    }

    @JvmName("mrlgbmmjtidbhynw")
    public suspend fun parameters(vararg values: Output<ParameterDefinitionArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("wvtffyyyhopvypah")
    public suspend fun parameters(values: List<Output<ParameterDefinitionArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rhcoyvqskoibsevf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The reference to an existing pipeline topology defined for real-time content processing. When activated, this live pipeline will process content according to the pipeline topology definition.
     */
    @JvmName("kigxaxlbiafctlep")
    public suspend fun topologyName(`value`: Output<String>) {
        this.topologyName = value
    }

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("ivimmbkenbxwsopl")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to see if the camera bitrate is now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
     */
    @JvmName("jwivepwbgrjfpvaf")
    public suspend fun bitrateKbps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrateKbps = mapped
    }

    /**
     * @param value An optional description for the pipeline.
     */
    @JvmName("jlogbjntihkttjge")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Live pipeline unique identifier.
     */
    @JvmName("ihydbmkbcceynbmm")
    public suspend fun livePipelineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livePipelineName = mapped
    }

    /**
     * @param value List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("kxwfpixblqqgmvoq")
    public suspend fun parameters(`value`: List<ParameterDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("aashofnyquxuinhb")
    public suspend fun parameters(argument: List<suspend ParameterDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("iyodnfgcaotcehon")
    public suspend fun parameters(
        vararg
        argument: suspend ParameterDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ParameterDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("xqekfhaiiyycuqbd")
    public suspend fun parameters(argument: suspend ParameterDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ParameterDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("ghuwyphrocubcaed")
    public suspend fun parameters(vararg values: ParameterDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("whhtqxqfliynsyxr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The reference to an existing pipeline topology defined for real-time content processing. When activated, this live pipeline will process content according to the pipeline topology definition.
     */
    @JvmName("mvjqvpiqhhrkwvil")
    public suspend fun topologyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topologyName = mapped
    }

    internal fun build(): LivePipelineArgs = LivePipelineArgs(
        accountName = accountName,
        bitrateKbps = bitrateKbps,
        description = description,
        livePipelineName = livePipelineName,
        parameters = parameters,
        resourceGroupName = resourceGroupName,
        topologyName = topologyName,
    )
}
