@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.PipelineJobArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.ParameterDefinitionArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.ParameterDefinitionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Pipeline job represents a unique instance of a batch topology, used for offline processing of selected portions of archived content.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * ## Example Usage
 * ### Create or update a pipeline job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipelineJob = new AzureNative.VideoAnalyzer.PipelineJob("pipelineJob", new()
 *     {
 *         AccountName = "testaccount2",
 *         Description = "Pipeline Job 1 Dsecription",
 *         Parameters = new[]
 *         {
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDefinitionArgs
 *             {
 *                 Name = "timesequences",
 *                 Value = "[[\"2020-10-05T03:30:00Z\", \"2020-10-05T04:30:00Z\"]]",
 *             },
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDefinitionArgs
 *             {
 *                 Name = "videoSourceName",
 *                 Value = "camera001",
 *             },
 *         },
 *         PipelineJobName = "pipelineJob1",
 *         ResourceGroupName = "testrg",
 *         TopologyName = "pipelinetopology1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewPipelineJob(ctx, "pipelineJob", &videoanalyzer.PipelineJobArgs{
 * 			AccountName: pulumi.String("testaccount2"),
 * 			Description: pulumi.String("Pipeline Job 1 Dsecription"),
 * 			Parameters: []videoanalyzer.ParameterDefinitionArgs{
 * 				{
 * 					Name:  pulumi.String("timesequences"),
 * 					Value: pulumi.String("[[\"2020-10-05T03:30:00Z\", \"2020-10-05T04:30:00Z\"]]"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("videoSourceName"),
 * 					Value: pulumi.String("camera001"),
 * 				},
 * 			},
 * 			PipelineJobName:   pulumi.String("pipelineJob1"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			TopologyName:      pulumi.String("pipelinetopology1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.PipelineJob;
 * import com.pulumi.azurenative.videoanalyzer.PipelineJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipelineJob = new PipelineJob("pipelineJob", PipelineJobArgs.builder()
 *             .accountName("testaccount2")
 *             .description("Pipeline Job 1 Dsecription")
 *             .parameters(
 *                 Map.ofEntries(
 *                     Map.entry("name", "timesequences"),
 *                     Map.entry("value", "[[\"2020-10-05T03:30:00Z\", \"2020-10-05T04:30:00Z\"]]")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "videoSourceName"),
 *                     Map.entry("value", "camera001")
 *                 ))
 *             .pipelineJobName("pipelineJob1")
 *             .resourceGroupName("testrg")
 *             .topologyName("pipelinetopology1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:PipelineJob pipelineJob1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineJobs/{pipelineJobName}
 * ```
 * @property accountName The Azure Video Analyzer account name.
 * @property description An optional description for the pipeline.
 * @property parameters List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
 * @property pipelineJobName The pipeline job name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property topologyName Reference to an existing pipeline topology. When activated, this pipeline job will process content according to the pipeline topology definition.
 */
public data class PipelineJobArgs(
    public val accountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val parameters: Output<List<ParameterDefinitionArgs>>? = null,
    public val pipelineJobName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val topologyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.PipelineJobArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.PipelineJobArgs =
        com.pulumi.azurenative.videoanalyzer.PipelineJobArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pipelineJobName(pipelineJobName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .topologyName(topologyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineJobArgs].
 */
@PulumiTagMarker
public class PipelineJobArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var description: Output<String>? = null

    private var parameters: Output<List<ParameterDefinitionArgs>>? = null

    private var pipelineJobName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var topologyName: Output<String>? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("wcxhotqmdtsndlpt")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value An optional description for the pipeline.
     */
    @JvmName("xetxysmbqqbfiiac")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("yhggndngyjuegocg")
    public suspend fun parameters(`value`: Output<List<ParameterDefinitionArgs>>) {
        this.parameters = value
    }

    @JvmName("diewcrlvglialthf")
    public suspend fun parameters(vararg values: Output<ParameterDefinitionArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("umnqtgemplniugko")
    public suspend fun parameters(values: List<Output<ParameterDefinitionArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The pipeline job name.
     */
    @JvmName("rmjakuamclowvonm")
    public suspend fun pipelineJobName(`value`: Output<String>) {
        this.pipelineJobName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mwmrgpiogricuvup")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Reference to an existing pipeline topology. When activated, this pipeline job will process content according to the pipeline topology definition.
     */
    @JvmName("robwlbilbyfxjlsv")
    public suspend fun topologyName(`value`: Output<String>) {
        this.topologyName = value
    }

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("rpfscgjnfwetgyyx")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value An optional description for the pipeline.
     */
    @JvmName("yihywadgggapxdae")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("gmufucakfruidpsj")
    public suspend fun parameters(`value`: List<ParameterDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("ymxpbmvalinqfnrh")
    public suspend fun parameters(argument: List<suspend ParameterDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("reejvqesbjxrspnj")
    public suspend fun parameters(
        vararg
        argument: suspend ParameterDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ParameterDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("puekyjxeachnrnpc")
    public suspend fun parameters(argument: suspend ParameterDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ParameterDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    @JvmName("nxyfckrdbrkkdqpm")
    public suspend fun parameters(vararg values: ParameterDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The pipeline job name.
     */
    @JvmName("ixegtcdvvymqttva")
    public suspend fun pipelineJobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineJobName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eveocqxxhhmxopbq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Reference to an existing pipeline topology. When activated, this pipeline job will process content according to the pipeline topology definition.
     */
    @JvmName("phurwbuuopiyscpj")
    public suspend fun topologyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topologyName = mapped
    }

    internal fun build(): PipelineJobArgs = PipelineJobArgs(
        accountName = accountName,
        description = description,
        parameters = parameters,
        pipelineJobName = pipelineJobName,
        resourceGroupName = resourceGroupName,
        topologyName = topologyName,
    )
}
