@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.VideoAnalyzerArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.AccountEncryptionArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.AccountEncryptionArgsBuilder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.IotHubArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.IotHubArgsBuilder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.NetworkAccessControlArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.NetworkAccessControlArgsBuilder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.StorageAccountArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.StorageAccountArgsBuilder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.VideoAnalyzerIdentityArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.VideoAnalyzerIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Video Analyzer account.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2021-05-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:VideoAnalyzer contosomovies /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}
 * ```
 * @property accountName The Video Analyzer account name.
 * @property encryption The account encryption properties.
 * @property identity The identities associated to the Video Analyzer resource.
 * @property iotHubs The IoT Hubs for this resource.
 * @property location The geo-location where the resource lives
 * @property networkAccessControl Network access control for Video Analyzer.
 * @property publicNetworkAccess Whether or not public network access is allowed for resources under the Video Analyzer account.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageAccounts The storage accounts for this resource.
 * @property tags Resource tags.
 */
public data class VideoAnalyzerArgs(
    public val accountName: Output<String>? = null,
    public val encryption: Output<AccountEncryptionArgs>? = null,
    public val identity: Output<VideoAnalyzerIdentityArgs>? = null,
    public val iotHubs: Output<List<IotHubArgs>>? = null,
    public val location: Output<String>? = null,
    public val networkAccessControl: Output<NetworkAccessControlArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccounts: Output<List<StorageAccountArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.VideoAnalyzerArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.VideoAnalyzerArgs =
        com.pulumi.azurenative.videoanalyzer.VideoAnalyzerArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .iotHubs(
                iotHubs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .networkAccessControl(
                networkAccessControl?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccounts(
                storageAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VideoAnalyzerArgs].
 */
@PulumiTagMarker
public class VideoAnalyzerArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var encryption: Output<AccountEncryptionArgs>? = null

    private var identity: Output<VideoAnalyzerIdentityArgs>? = null

    private var iotHubs: Output<List<IotHubArgs>>? = null

    private var location: Output<String>? = null

    private var networkAccessControl: Output<NetworkAccessControlArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccounts: Output<List<StorageAccountArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Video Analyzer account name.
     */
    @JvmName("xdwcnltmjgqnlyar")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The account encryption properties.
     */
    @JvmName("jotfhtakxwstpkgc")
    public suspend fun encryption(`value`: Output<AccountEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The identities associated to the Video Analyzer resource.
     */
    @JvmName("pojfivyujunmwbse")
    public suspend fun identity(`value`: Output<VideoAnalyzerIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The IoT Hubs for this resource.
     */
    @JvmName("itrujnndconvdwdw")
    public suspend fun iotHubs(`value`: Output<List<IotHubArgs>>) {
        this.iotHubs = value
    }

    @JvmName("vnkkoowmxndridgh")
    public suspend fun iotHubs(vararg values: Output<IotHubArgs>) {
        this.iotHubs = Output.all(values.asList())
    }

    /**
     * @param values The IoT Hubs for this resource.
     */
    @JvmName("ermgppyannqexogb")
    public suspend fun iotHubs(values: List<Output<IotHubArgs>>) {
        this.iotHubs = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("emeympgjygdexjri")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Network access control for Video Analyzer.
     */
    @JvmName("iamshybsexwrpwbw")
    public suspend fun networkAccessControl(`value`: Output<NetworkAccessControlArgs>) {
        this.networkAccessControl = value
    }

    /**
     * @param value Whether or not public network access is allowed for resources under the Video Analyzer account.
     */
    @JvmName("qjqivcbbyeoreywe")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hxsiehrosqqotahb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The storage accounts for this resource.
     */
    @JvmName("yfxunwhqmbxwyich")
    public suspend fun storageAccounts(`value`: Output<List<StorageAccountArgs>>) {
        this.storageAccounts = value
    }

    @JvmName("fvcxxcqmfvqypydj")
    public suspend fun storageAccounts(vararg values: Output<StorageAccountArgs>) {
        this.storageAccounts = Output.all(values.asList())
    }

    /**
     * @param values The storage accounts for this resource.
     */
    @JvmName("iskedoyqntjhhxvu")
    public suspend fun storageAccounts(values: List<Output<StorageAccountArgs>>) {
        this.storageAccounts = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ogemooivakvhrejc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Video Analyzer account name.
     */
    @JvmName("hauchxkjnlowopjp")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The account encryption properties.
     */
    @JvmName("gfdvggkmcjysxmfu")
    public suspend fun encryption(`value`: AccountEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument The account encryption properties.
     */
    @JvmName("dkuslgybcmwwgkjt")
    public suspend fun encryption(argument: suspend AccountEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = AccountEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The identities associated to the Video Analyzer resource.
     */
    @JvmName("mvjajhivdyvmtrqo")
    public suspend fun identity(`value`: VideoAnalyzerIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identities associated to the Video Analyzer resource.
     */
    @JvmName("pdansaqkmtpekqld")
    public suspend fun identity(argument: suspend VideoAnalyzerIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = VideoAnalyzerIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The IoT Hubs for this resource.
     */
    @JvmName("rqkbhfbdddottqjt")
    public suspend fun iotHubs(`value`: List<IotHubArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotHubs = mapped
    }

    /**
     * @param argument The IoT Hubs for this resource.
     */
    @JvmName("nwhdvbnbqqijxamj")
    public suspend fun iotHubs(argument: List<suspend IotHubArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IotHubArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.iotHubs = mapped
    }

    /**
     * @param argument The IoT Hubs for this resource.
     */
    @JvmName("uypbbrlssjxlkjlf")
    public suspend fun iotHubs(vararg argument: suspend IotHubArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IotHubArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.iotHubs = mapped
    }

    /**
     * @param argument The IoT Hubs for this resource.
     */
    @JvmName("yxcnbduklpfvevle")
    public suspend fun iotHubs(argument: suspend IotHubArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IotHubArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.iotHubs = mapped
    }

    /**
     * @param values The IoT Hubs for this resource.
     */
    @JvmName("obuwyafkxoqjbfkp")
    public suspend fun iotHubs(vararg values: IotHubArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iotHubs = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("apywymfguvfwkkdc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Network access control for Video Analyzer.
     */
    @JvmName("pwxcstatlllonfei")
    public suspend fun networkAccessControl(`value`: NetworkAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAccessControl = mapped
    }

    /**
     * @param argument Network access control for Video Analyzer.
     */
    @JvmName("gufaokcptucvvmlf")
    public suspend
    fun networkAccessControl(argument: suspend NetworkAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkAccessControl = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for resources under the Video Analyzer account.
     */
    @JvmName("fiufjeiyqvconloq")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for resources under the Video Analyzer account.
     */
    @JvmName("njirobkelkviwsja")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for resources under the Video Analyzer account.
     */
    @JvmName("athfutspbggyfaww")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kgvchsrgwygdoymn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The storage accounts for this resource.
     */
    @JvmName("shhvblpvexcmpbcg")
    public suspend fun storageAccounts(`value`: List<StorageAccountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param argument The storage accounts for this resource.
     */
    @JvmName("eboqqaslacscstvi")
    public suspend fun storageAccounts(argument: List<suspend StorageAccountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument The storage accounts for this resource.
     */
    @JvmName("fvynffjtalhhygym")
    public suspend fun storageAccounts(
        vararg
        argument: suspend StorageAccountArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument The storage accounts for this resource.
     */
    @JvmName("nyaqqjnbmmhoalvv")
    public suspend fun storageAccounts(argument: suspend StorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageAccountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param values The storage accounts for this resource.
     */
    @JvmName("ykpcgmnvmnedqkub")
    public suspend fun storageAccounts(vararg values: StorageAccountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lftfohugbyqunabi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cnpufnbmyplkwsau")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VideoAnalyzerArgs = VideoAnalyzerArgs(
        accountName = accountName,
        encryption = encryption,
        identity = identity,
        iotHubs = iotHubs,
        location = location,
        networkAccessControl = networkAccessControl,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        storageAccounts = storageAccounts,
        tags = tags,
    )
}
