@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Topology kind.
 */
public enum class Kind(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.Kind,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.Kind> {
    /**
     * Live pipeline topology resource.
     */
    Live(com.pulumi.azurenative.videoanalyzer.enums.Kind.Live),

    /**
     * Batch pipeline topology resource.
     */
    Batch(com.pulumi.azurenative.videoanalyzer.enums.Kind.Batch),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.Kind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.Kind): Kind =
            Kind.values().first { it.javaValue == javaType }
    }
}
