@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The SKU name.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.SkuName> {
    /**
     * Represents the Live S1 SKU name. Using this SKU you can create live pipelines to capture, record, and stream live video from RTSP-capable cameras at bitrate settings from 0.5 Kbps to 3000 Kbps.
     */
    Live_S1(com.pulumi.azurenative.videoanalyzer.enums.SkuName.Live_S1),

    /**
     * Represents the Batch S1 SKU name. Using this SKU you can create pipeline jobs to process recorded content.
     */
    Batch_S1(com.pulumi.azurenative.videoanalyzer.enums.SkuName.Batch_S1),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
