@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.EncoderSystemPresetArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.enums.EncoderSystemPresetType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a built-in preset for encoding the input content using the encoder processor.
 * @property name Name of the built-in encoding preset.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.EncoderSystemPreset'.
 */
public data class EncoderSystemPresetArgs(
    public val name: Output<Either<String, EncoderSystemPresetType>>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.EncoderSystemPresetArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.EncoderSystemPresetArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.EncoderSystemPresetArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncoderSystemPresetArgs].
 */
@PulumiTagMarker
public class EncoderSystemPresetArgsBuilder internal constructor() {
    private var name: Output<Either<String, EncoderSystemPresetType>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name of the built-in encoding preset.
     */
    @JvmName("tlurcllleaslqeoy")
    public suspend fun name(`value`: Output<Either<String, EncoderSystemPresetType>>) {
        this.name = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.EncoderSystemPreset'.
     */
    @JvmName("snxwnhoabtbwkaru")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name of the built-in encoding preset.
     */
    @JvmName("ovufpepbuqfhlbyd")
    public suspend fun name(`value`: Either<String, EncoderSystemPresetType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the built-in encoding preset.
     */
    @JvmName("vsywpwedauhxutdd")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncoderSystemPresetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the built-in encoding preset.
     */
    @JvmName("ctuxfaykepikindd")
    public fun name(`value`: EncoderSystemPresetType) {
        val toBeMapped = Either.ofRight<String, EncoderSystemPresetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.EncoderSystemPreset'.
     */
    @JvmName("vjcwypiwqokwlijk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EncoderSystemPresetArgs = EncoderSystemPresetArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
