@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.GetEdgeModulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Azure Video Analyzer account name.
 * @property edgeModuleName The Edge Module name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEdgeModulePlainArgs(
    public val accountName: String,
    public val edgeModuleName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.GetEdgeModulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.GetEdgeModulePlainArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.GetEdgeModulePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .edgeModuleName(edgeModuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEdgeModulePlainArgs].
 */
@PulumiTagMarker
public class GetEdgeModulePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var edgeModuleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("miuhxmhnwsdvccbd")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Edge Module name.
     */
    @JvmName("iftjwwuixuqbrndw")
    public suspend fun edgeModuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.edgeModuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ebqmvitpsvumthea")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEdgeModulePlainArgs = GetEdgeModulePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        edgeModuleName = edgeModuleName ?: throw PulumiNullFieldException("edgeModuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
