@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.GetPipelineTopologyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Azure Video Analyzer account name.
 * @property pipelineTopologyName Pipeline topology unique identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPipelineTopologyPlainArgs(
    public val accountName: String,
    public val pipelineTopologyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.GetPipelineTopologyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.GetPipelineTopologyPlainArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.GetPipelineTopologyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .pipelineTopologyName(pipelineTopologyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelineTopologyPlainArgs].
 */
@PulumiTagMarker
public class GetPipelineTopologyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var pipelineTopologyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("oscesnxkjxyfewjy")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Pipeline topology unique identifier.
     */
    @JvmName("khcnoqsfmpoexerj")
    public suspend fun pipelineTopologyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineTopologyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ljqimjkswllbddne")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPipelineTopologyPlainArgs = GetPipelineTopologyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        pipelineTopologyName = pipelineTopologyName ?: throw
            PulumiNullFieldException("pipelineTopologyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
