@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.GroupLevelAccessControlArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.enums.PublicNetworkAccess
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Group level network access control.
 * @property publicNetworkAccess Whether or not public network access is allowed for specified resources under the Video Analyzer account.
 */
public data class GroupLevelAccessControlArgs(
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.GroupLevelAccessControlArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.GroupLevelAccessControlArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.GroupLevelAccessControlArgs.builder()
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [GroupLevelAccessControlArgs].
 */
@PulumiTagMarker
public class GroupLevelAccessControlArgsBuilder internal constructor() {
    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    /**
     * @param value Whether or not public network access is allowed for specified resources under the Video Analyzer account.
     */
    @JvmName("grrsputmrtkwcewo")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Whether or not public network access is allowed for specified resources under the Video Analyzer account.
     */
    @JvmName("efaryjiiybykbkdw")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for specified resources under the Video Analyzer account.
     */
    @JvmName("olcgfhuqtuhjcfgl")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for specified resources under the Video Analyzer account.
     */
    @JvmName("ywdxqkvucwxwwsgg")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    internal fun build(): GroupLevelAccessControlArgs = GroupLevelAccessControlArgs(
        publicNetworkAccess = publicNetworkAccess,
    )
}
