@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.ParameterDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the parameter value of an specific pipeline topology parameter. See pipeline topology parameters for more information.
 * @property name Name of the parameter declared in the pipeline topology.
 * @property value Parameter value to be applied on this specific pipeline.
 */
public data class ParameterDefinitionArgs(
    public val name: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.ParameterDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.ParameterDefinitionArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.ParameterDefinitionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterDefinitionArgs].
 */
@PulumiTagMarker
public class ParameterDefinitionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the parameter declared in the pipeline topology.
     */
    @JvmName("rbpngtnlypypsqkg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Parameter value to be applied on this specific pipeline.
     */
    @JvmName("dpoaupprcnqylyuv")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the parameter declared in the pipeline topology.
     */
    @JvmName("mrwyrbxpiriyfqdl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Parameter value to be applied on this specific pipeline.
     */
    @JvmName("vyrgjwmunovakpqh")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ParameterDefinitionArgs = ParameterDefinitionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value`,
    )
}
