@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.StorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The details about the associated storage account.
 * @property id The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
 * @property identity A managed identity that Video Analyzer will use to access the storage account.
 */
public data class StorageAccountArgs(
    public val id: Output<String>,
    public val identity: Output<ResourceIdentityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.StorageAccountArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.StorageAccountArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    /**
     * @param value The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
     */
    @JvmName("gypnrabbwuyajrrs")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value A managed identity that Video Analyzer will use to access the storage account.
     */
    @JvmName("vvljyjkfqwfsddhh")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
     */
    @JvmName("amdysoxewvfnsvbs")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value A managed identity that Video Analyzer will use to access the storage account.
     */
    @JvmName("ridtfeisoqdvhgrn")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument A managed identity that Video Analyzer will use to access the storage account.
     */
    @JvmName("enkwxcuaxqluhpik")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        identity = identity,
    )
}
