@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoAnalyzerIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The managed identity for the Video Analyzer resource.
 * @property type The identity type.
 * @property userAssignedIdentities The User Assigned Managed Identities.
 */
public data class VideoAnalyzerIdentityArgs(
    public val type: Output<String>,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoAnalyzerIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoAnalyzerIdentityArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoAnalyzerIdentityArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [VideoAnalyzerIdentityArgs].
 */
@PulumiTagMarker
public class VideoAnalyzerIdentityArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("ddnshjboymgbaqhi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The User Assigned Managed Identities.
     */
    @JvmName("mykepcyibcdmiidt")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("ldqbvmheyvpimvxt")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The User Assigned Managed Identities.
     */
    @JvmName("refumuvplaogyunt")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The identity type.
     */
    @JvmName("wccteyikmytrlkxm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The User Assigned Managed Identities.
     */
    @JvmName("xpkejfxltysqhyki")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The User Assigned Managed Identities.
     */
    @JvmName("nsytwptrxpetjohc")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): VideoAnalyzerIdentityArgs = VideoAnalyzerIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
